@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('reports.info_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-between">
									<div class="report-btns">
										<a href="{{ route('reports.member_information', ['type' => 'csv'] ) }}"
											class="btn btn-default"><i class="fas fa-file-csv"></i> {{
											__('reports.export') }}</a>
										<a href="{{ route('reports.member_information', ['type' => 'print'] ) }}"
											rel="noopener" target="_blank" class="btn btn-default"><i
												class="fas fa-print"></i> {{ __('reports.print') }}</a>
									</div>
									<form class="w-25" method="post" action="{{ route('reports.member_information') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<select class="form-control " name="search" required>
												<option value="all" {{ $keyword=="all" ? "selected" : "" }}>
													All Status
												</option>
												<option value="valid" {{ $keyword=="valid" ? "selected" : "" }}>
													Valid
												</option>
												<option value="expired" {{ $keyword=="expired" ? "selected" : "" }}>
													Expired
												</option>
												<option value="near_expiry" {{ $keyword=="near_expiry" ? "selected" : ""
													}}>
													Near Expiry
												</option>
											</select>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap">{{ __('reports.th_reg_no') }}</th>
													<th>{{ __('reports.th_member_name') }}</th>
													<th>{{ __('reports.th_phone') }}</th>
													<th class="nowrap">{{ __('reports.th_membership_type') }}</th>
													<th class="nowrap">{{ __('reports.th_valid_from') }}</th>
													<th class="nowrap">{{ __('reports.th_valid_to') }}</th>
													<th class="nowrap fixed-width-td">{{ __('reports.th_status') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($members as $member)
												<tr>
													<td class="align-middle">{{ $member->reg_no }}</td>
													<td class="align-middle nowrap">{{ $member->name }}</td>
													<td class="align-middle">{{ $member->phone }}</td>
													<td class="align-middle nowrap">{{ $member->membership_name }}</td>
													<td class="align-middle nowrap">{{ format_date($member->valid_from)
														}}</td>
													<td class="align-middle nowrap">{{ format_date($member->valid_to) }}
													</td>
													<td class="align-middle nowrap">{!!
														membership_status($member->valid_to) !!}</td>
												</tr>
												@endforeach
												@if(count($members) == 0)
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">{{ __('reports.no_record_found') }}
														</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $members->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection